(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     47804,       1997]*)
(*NotebookOutlinePosition[     48644,       2024]*)
(*  CellTagsIndexPosition[     48600,       2020]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions for On-line Help", "Subtitle"],

Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Subsubsection"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Subsubsection"],

Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"]}, {Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageFooters->{{None, Cell[ 
          TextData[
           {"\[Copyright]1997 Wolfram Research, Inc. All rights reserved."}], 
          "PageFooter"], None}, {None, Cell[ 
          TextData[
           {"\[Copyright]1997 Wolfram Research, Inc. All rights reserved."}], 
          "PageFooter"], None}},
  PageHeaderLines->{True, True},
  PageFooterLines->{True, True},
  PrintingOptions->{"FacingPages"->True},
  CellLabelAutoDelete->False,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Chapter"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {4, 24}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold"],

Cell[StyleData["Chapter", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->22]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {12, 18}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  ShowCellBracket->False,
  CellMargins->{{24, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellFrameLabelMargins->6,
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{16, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionColor"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.297993, 0, 0.454994]],

Cell[StyleData["SubsubsectionColor", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionIcon"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{24, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->8},
  CellGroupingRules->{"SectionGrouping", 50},
  CounterIncrements->"Section",
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["SubsectionIcon", "Printout"],
  CellDingbat->"\[FilledSquare]",
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{16, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionIcon"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{24, 4}, {0, 8}},
  CellElementSpacings->{"ClosedGroupTopMargin"->4},
  CellGroupingRules->{"SectionGrouping", 60},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubection", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["SubsubsectionIcon", "Printout"],
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ParagraphSpacing->{0, 8}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CompactText"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  ParagraphSpacing->{0, 0},
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["CompactText", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Compact12Text"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  ParagraphSpacing->{0, 0},
  StyleMenuListing->None],

Cell[StyleData["Compact12Text", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSans"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["TextSans", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {0, 8}},
  ParagraphSpacing->{0, 8},
  ParagraphIndent->-15,
  StyleMenuListing->None],

Cell[StyleData["ItemizedText", "Printout"],
  CellMargins->{{12, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  ShowCellBracket->False,
  CellMargins->{{35, 4}, {0, 4}},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None],

Cell[StyleData["ItemizedTextNote", "Printout"],
  CellMargins->{{27, 0}, {0, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {0, 6}},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None],

Cell[StyleData["IndentedText", "Printout"],
  CellMargins->{{12, 0}, {0, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellDingbat->"\[FilledSmallSquare]",
  ShowCellBracket->False,
  CellMargins->{{19, 62}, {0, 14}},
  PageBreakBelow->False,
  CellFrameLabelMargins->4,
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{9, 0}, {0, 14}},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"SmallText",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  TextJustification->1,
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Subsubsection"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{46, 4}, {3, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 4}, {4, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->StandardForm],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{47, 4}, {4, 2}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{47, 4}, {4, 2}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{47, 4}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultFormatTypeForOutput,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontWeight->"Plain"],

Cell[StyleData["Graphics", "Printout"],
  ShowCellBracket->False,
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->7,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Name"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Name", "Printout"],
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Subsubsection"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Subsubsection"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["JT"],
  StyleMenuListing->None,
  FontFamily->"JFontText"],

Cell[StyleData["JS"],
  StyleMenuListing->None,
  FontFamily->"JFontSans"],

Cell[StyleData["JSB"],
  StyleMenuListing->None,
  FontFamily->"JFontSansBold"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["M4"],
  ShowCellBracket->True,
  StyleMenuListing->None,
  FontFamily->"Math4",
  CharacterEncoding->"Math4"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1"],
  StyleMenuListing->None,
  FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1", "Printout"],
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1MR"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1MR", "Printout"],
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Emphasis Boxes and Pictures", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Box"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["Box", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->2,
  RowAlignments->Top}],

Cell[StyleData["DoubleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["1ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.31, 0.62}}],

Cell[StyleData["2ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.46}],

Cell[StyleData["2ColumnEvenBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.35,
  ColumnAlignments->{Right, Left}}],

Cell[StyleData["2ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.31}],

Cell[StyleData["3ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.24,
  ColumnAlignments->{Right, Center, Left}}],

Cell[StyleData["3ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.13, 0.33, 0.13, 0.33}}],

Cell[StyleData["4ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.194}],

Cell[StyleData["5ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],

Cell[StyleData["6ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNoteBox"],
  CellFrame->0.5,
  ShowCellBracket->False,
  CellMargins->{{37, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[1, 0.6, 0.6],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["ItemizedNoteBox", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox"],
  CellFrame->0.5,
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.3, 0.7},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox3Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.2, 0.3, 0.5},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox3Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox4Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.15, 0.35, 0.15, 0.35},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox4Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox5Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->0.2,
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox5Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox6Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox6Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{11, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  ShowCellBracket->False,
  CellMargins->{{11, 4}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 0}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BottomBox"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  ShowCellBracket->False,
  CellMargins->{{11, 4}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["BottomBox", "Printout"],
  CellMargins->{{2, 4}, {0, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{11, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopSpanBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  ShowCellBracket->False,
  CellMargins->{{11, 4}, {0, 0}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleSpanBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  ShowCellBracket->False,
  CellMargins->{{10, Inherited}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedPicture"],
  ShowCellBracket->False,
  CellMargins->{{35, 4}, {0, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemizedPicture", "Printout"],
  CellMargins->{{27, 0}, {0, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellMargins->{{10, Inherited}, {0, 8}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Sound"],
  CellMargins->{{10, Inherited}, {0, 8}},
  StyleMenuListing->None],

Cell[StyleData["Sound", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 3}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{2, 0}, {0, 3}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.34, 0.64},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenTable"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.49,
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnEvenTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineOutput"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["InlineOutput", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  ShowCellBracket->False,
  CellMargins->{{42, Inherited}, {Inherited, 10}},
  CellHorizontalScrolling->True,
  ScriptLevel->0,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{34, Inherited}, {Inherited, 10}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayMath"],
  ShowCellBracket->False,
  CellMargins->{{42, 10}, {7, 7}},
  Evaluatable->False,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input"],

Cell[StyleData["DisplayMath", "Printout"],
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  ShowCellBracket->False,
  CellMargins->{{42, 10}, {7, 7}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{34, 55}, {0, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
  LineSpacing->{1.83, 0}],

Cell[StyleData["EquationNumber", "Printout"],
  LineSpacing->{1.7, 0}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  ShowCellBracket->False,
  CellMargins->{{16, Inherited}, {Inherited, 10}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{8, Inherited}, {Inherited, 10}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Help Browser Styles", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["ObjectName"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {1, 10}},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["ObjectName", "Printout"],
  CellMargins->{{2, 0}, {1, 10}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Command"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 14}},
  CounterIncrements->"Section",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Command", "Printout"],
  CellMargins->{{2, 0}, {0, 14}},
  PageBreakBelow->False,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CharacterName"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 4}},
  CellFrameMargins->4,
  StyleMenuListing->None],

Cell[StyleData["CharacterName", "Printout"],
  CellMargins->{{2, 0}, {0, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Usage"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 4}},
  CellFrameMargins->5,
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None],

Cell[StyleData["Usage", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Notes"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["Notes", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotesList"],
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {2, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["NotesList", "Printout"],
  CellMargins->{{12, 0}, {2, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{11, 4}, {0, 10}},
  CellGroupingRules->{"SectionGrouping", 70},
  CellFrameMargins->12,
  StyleMenuListing->None,
  FontSize->13,
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["ExampleSection", "Printout"],
  CellMargins->{{3, 0}, {0, 10}},
  PageBreakBelow->False,
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleText"],
  ShowCellBracket->True,
  CellMargins->{{20, 40}, {0, 18}},
  ParagraphSpacing->{0, 6},
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["ExampleText", "Printout"],
  CellMargins->{{2, 80}, {0, 8}},
  PageBreakBelow->False,
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSubsection"],
  ShowCellBracket->True,
  CellMargins->{{20, 4}, {0, 16}},
  CellGroupingRules->{"SectionGrouping", 80},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["ExampleSubsection", "Printout"],
  CellMargins->{{12, 0}, {0, 16}},
  PageBreakBelow->False,
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LineHead"],
  CellFrame->{{0, 0}, {0.5, 0}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {8, 18}},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["LineHead", "Printout"],
  CellMargins->{{2, 0}, {8, 18}},
  PageBreakBelow->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushInput"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {1, 4}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["FlushInput", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{2, 0}, {1, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushOutput"],
  ShowCellBracket->False,
  CellMargins->{{10, Inherited}, {Inherited, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->StandardForm,
  StyleMenuListing->None],

Cell[StyleData["FlushOutput", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{2, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DialogItem"],
  CellDingbat->"\[EmptyDiamond]",
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {0, 12}},
  CellGroupingRules->{"SectionGrouping", 70},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["DialogItem", "Printout"],
  CellMargins->{{12, 0}, {0, 12}},
  PageBreakBelow->False,
  FontSize->8]
}, Closed]],

Cell[StyleData["GroupDivider"],
  ShowCellBracket->False,
  CellMargins->{{10, Inherited}, {Inherited, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->{"TitleGrouping", 0},
  StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Highlight"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 18}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Highlight", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  LineSpacing->{1, 3}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserNotes"],
  CellFrame->{{2, 0}, {0, 0.25}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 4}},
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["UserNotes", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MoreInfo"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 4}},
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.700008, 0.4, 0.100008]],

Cell[StyleData["MoreInfo", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserTips"],
  CellFrame->{{2, 0}, {0, 0.25}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 4}},
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.500008, 0.700008]],

Cell[StyleData["UserTips", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  LineSpacing->{1, 3},
  FontSize->8,
  Background->GrayLevel[0.700008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
  CellFrame->{{4, 0}, {0, 0}},
  ShowCellBracket->False,
  CellMargins->{{12, 62}, {0, 14}},
  CellFrameMargins->4,
  CellFrameColor->RGBColor[0, 0, 0.8],
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8}],

Cell[StyleData["Theorem", "Printout"],
  CellMargins->{{2, 0}, {0, 14}},
  CellFrameMargins->3,
  CellFrameColor->GrayLevel[0.8],
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellFrame->{{2, 0}, {0, 0}},
  ShowCellBracket->False,
  CellMargins->{{36, 10}, {7, 7}},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CellFrameColor->RGBColor[0, 0.2, 1],
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  FontSlant->"Italic"],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{32, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents and Index", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["ContentsTitle"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {0, 18}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["ContentsTitle", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ContentsSection"],
  CellDingbat->"\[FilledSquare]",
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {3, 18}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["ContentsSection", "Printout"],
  CellMargins->{{12, 0}, {3, 18}},
  PageBreakBelow->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSection"],
  CellDingbat->"\[FilledSquare]",
  ShowCellBracket->False,
  CellMargins->{{20, 4}, {5, 20}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["IndexSection", "Printout"],
  CellMargins->{{12, 0}, {5, 20}},
  PageBreakBelow->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Contents"],
  ShowCellBracket->False,
  CellMargins->{{21, 4}, {0, 8}},
  StyleMenuListing->None],

Cell[StyleData["Contents", "Printout"],
  CellMargins->{{13, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index"],
  ShowCellBracket->False,
  CellMargins->{{21, 4}, {0, 0}},
  ParagraphIndent->-48,
  StyleMenuListing->None],

Cell[StyleData["Index", "Printout"],
  CellMargins->{{13, 0}, {0, 0}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSubentry"],
  ShowCellBracket->False,
  CellMargins->{{36, 4}, {0, 0}},
  ParagraphIndent->-48,
  StyleMenuListing->None],

Cell[StyleData["IndexSubentry", "Printout"],
  CellMargins->{{24, 0}, {0, 0}},
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Horizontal Lines", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Line1"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {-16, 9}},
  StyleMenuListing->None,
  FontSize->2],

Cell[StyleData["Line1", "Printout"],
  CellMargins->{{2, 0}, {-16, 9}}]
}, Closed]],

Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramTop"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {-18, 18}},
  LineSpacing->{1, -4},
  StyleMenuListing->None,
  FontSize->4],

Cell[StyleData["ProgramTop", "Printout"],
  CellMargins->{{2, 0}, {-18, 18}}]
}, Closed]],

Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramBottom"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {-10, -2}},
  LineSpacing->{1, -4},
  StyleMenuListing->None,
  FontSize->4],

Cell[StyleData["ProgramBottom", "Printout"],
  CellMargins->{{2, 0}, {-10, -2}}]
}, Closed]],

Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["SessionLabel"],
  CellFrame->{{0.5, 0}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {-4, 18}},
  LineSpacing->{1, -3},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SessionLabel", "Printout"],
  CellMargins->{{2, 0}, {-4, 18}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Headers and Footers", "Subsubsection"],

Cell[StyleData["PageHeader"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontSize->8,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->8,
  FontWeight->"Bold"],

Cell[StyleData["PageFooter"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{489, 343},
WindowMargins->{{11, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 54, 0, 62, "Subtitle"],
Cell[1788, 53, 139, 3, 46, "Text"],

Cell[CellGroupData[{
Cell[1952, 60, 48, 0, 42, "Subsubsection"],
Cell[2003, 62, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2083, 66, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2260, 75, 41, 0, 28, "Subsubsection"],
Cell[2304, 77, 105, 3, 30, "Text"],
Cell[2412, 82, 1005, 23, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3454, 110, 33, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[3512, 114, 152, 5, 73, 26, 0, "StyleData", "Chapter", "All"],
Cell[3667, 121, 113, 3, 70, 38, 0, "StyleData", "Chapter", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3817, 129, 153, 5, 52, 26, 0, "StyleData", "Section", "All"],
Cell[3973, 136, 113, 3, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4123, 144, 270, 8, 50, 29, 0, "StyleData", "Subsection", "All"],
Cell[4396, 154, 117, 3, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4550, 162, 211, 6, 48, 32, 0, "StyleData", "Subsubsection", "All"],
Cell[4764, 170, 119, 3, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4920, 178, 288, 8, 48, 37, 0, "StyleData", "SubsubsectionColor", "All",
  StyleMenuListing->None],
Cell[5211, 188, 124, 3, 70, 49, 0, "StyleData", "SubsubsectionColor", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5372, 196, 321, 9, 40, 33, 0, "StyleData", "SubsectionIcon", "All",
  CounterIncrements->"Section"],
Cell[5696, 207, 188, 5, 70, 45, 0, "StyleData", "SubsectionIcon", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5921, 217, 371, 10, 34, 36, 0, "StyleData", "SubsubsectionIcon", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubection", 0}}],
Cell[6295, 229, 156, 4, 70, 48, 0, "StyleData", "SubsubsectionIcon", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6500, 239, 29, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[6554, 243, 144, 4, 36, 23, 0, "StyleData", "Text", "All"],
Cell[6701, 249, 68, 1, 36, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6806, 255, 160, 5, 31, 30, 0, "StyleData", "CompactText", "All",
  StyleMenuListing->None],
Cell[6969, 262, 90, 2, 70, 42, 0, "StyleData", "CompactText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7096, 269, 146, 4, 32, 32, 0, "StyleData", "Compact12Text", "All",
  StyleMenuListing->None],
Cell[7245, 275, 93, 2, 70, 44, 0, "StyleData", "Compact12Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7375, 282, 217, 7, 31, 27, 0, "StyleData", "TextSans", "All",
  StyleMenuListing->None],
Cell[7595, 291, 87, 2, 70, 39, 0, "StyleData", "TextSans", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7719, 298, 169, 5, 32, 31, 0, "StyleData", "ItemizedText", "All",
  StyleMenuListing->None],
Cell[7891, 305, 77, 1, 70, 43, 0, "StyleData", "ItemizedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8005, 311, 149, 4, 32, 35, 0, "StyleData", "ItemizedTextNote", "All",
  StyleMenuListing->None],
Cell[8157, 317, 81, 1, 70, 47, 0, "StyleData", "ItemizedTextNote", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[8275, 323, 145, 4, 32, 31, 0, "StyleData", "IndentedText", "All",
  StyleMenuListing->None],
Cell[8423, 329, 77, 1, 70, 43, 0, "StyleData", "IndentedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8537, 335, 269, 8, 32, 30, 0, "StyleData", "MathCaption", "All"],
Cell[8809, 345, 118, 3, 40, 42, 0, "StyleData", "MathCaption", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8964, 353, 190, 6, 30, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[9157, 361, 112, 3, 31, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9318, 370, 37, 0, 28, "Subsubsection"],
Cell[9358, 372, 252, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[9635, 381, 449, 13, 41, 24, 0, "StyleData", "Input", "All"],
Cell[10087, 396, 77, 2, 37, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10201, 403, 432, 12, 36, 25, 0, "StyleData", "Output", "All"],
Cell[10636, 417, 78, 2, 32, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10751, 424, 422, 12, 36, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[11176, 438, 106, 3, 32, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11319, 446, 388, 11, 36, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[11710, 459, 77, 2, 32, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11824, 466, 325, 10, 36, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[12152, 478, 80, 2, 32, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12269, 485, 151, 5, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[12423, 492, 130, 4, 31, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12590, 501, 169, 6, 34, 23, 0, "StyleData", "Name", "All",
  StyleMenuListing->None],
Cell[12762, 509, 77, 2, 70, 35, 0, "StyleData", "Name", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12888, 517, 35, 0, 28, "Subsubsection"],
Cell[12926, 519, 340, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[13291, 529, 325, 9, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[13619, 540, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13763, 547, 279, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None],
Cell[14045, 556, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14192, 563, 300, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None],
Cell[14495, 573, 107, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14639, 580, 308, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None],
Cell[14950, 590, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15097, 597, 291, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None],
Cell[15391, 606, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15544, 613, 295, 7, 70, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None],
Cell[15842, 622, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16009, 630, 42, 0, 28, "Subsubsection"],
Cell[16054, 632, 121, 3, 30, "Text"],
Cell[16178, 637, 74, 2, 39, 21, 0, "StyleData", "JT", "All",
  StyleMenuListing->None],
Cell[16255, 641, 74, 2, 39, 21, 0, "StyleData", "JS", "All",
  StyleMenuListing->None],
Cell[16332, 645, 79, 2, 39, 22, 0, "StyleData", "JSB", "All",
  StyleMenuListing->None],
Cell[16414, 649, 92, 3, 36, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[16509, 654, 69, 2, 37, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[16581, 658, 70, 2, 37, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[16654, 662, 115, 4, 36, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[16772, 668, 116, 4, 37, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[16891, 674, 114, 4, 37, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[17008, 680, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[17127, 686, 117, 4, 36, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[17247, 692, 118, 4, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[17368, 698, 116, 4, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[17487, 704, 118, 4, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[17608, 710, 119, 4, 37, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[17730, 716, 120, 4, 37, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[17853, 722, 118, 4, 37, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[17974, 728, 120, 4, 37, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],
Cell[18097, 734, 125, 4, 38, 21, 0, "StyleData", "M4", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[18247, 742, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[18388, 749, 149, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[18574, 759, 81, 2, 36, 21, 0, "StyleData", "C1", "All",
  StyleMenuListing->None],
Cell[18658, 763, 60, 1, 70, 33, 0, "StyleData", "C1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18755, 769, 108, 3, 36, 23, 0, "StyleData", "C1MR", "All",
  StyleMenuListing->None],
Cell[18866, 774, 62, 1, 70, 35, 0, "StyleData", "C1MR", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18977, 781, 52, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[19054, 785, 272, 7, 52, 22, 0, "StyleData", "Box", "All",
  StyleMenuListing->None],
Cell[19329, 794, 102, 2, 52, 34, 0, "StyleData", "Box", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19468, 801, 300, 8, 48, 28, 0, "StyleData", "DoubleBox", "All",
  StyleMenuListing->None],
Cell[19771, 811, 108, 2, 70, 40, 0, "StyleData", "DoubleBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19916, 818, 296, 8, 48, 29, 0, "StyleData", "1ColumnBox", "All",
  StyleMenuListing->None],
Cell[20215, 828, 109, 2, 52, 41, 0, "StyleData", "1ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20361, 835, 305, 8, 48, 29, 0, "StyleData", "2ColumnBox", "All",
  StyleMenuListing->None],
Cell[20669, 845, 109, 2, 70, 41, 0, "StyleData", "2ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20815, 852, 301, 8, 48, 33, 0, "StyleData", "2ColumnEvenBox", "All",
  StyleMenuListing->None],
Cell[21119, 862, 113, 2, 70, 45, 0, "StyleData", "2ColumnEvenBox", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[21269, 869, 360, 10, 48, 34, 0, "StyleData", "2ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[21632, 881, 114, 2, 70, 46, 0, "StyleData", "2ColumnSmallBox", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21783, 888, 297, 8, 48, 29, 0, "StyleData", "3ColumnBox", "All",
  StyleMenuListing->None],
Cell[22083, 898, 109, 2, 70, 41, 0, "StyleData", "3ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22229, 905, 368, 10, 48, 34, 0, "StyleData", "3ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[22600, 917, 114, 2, 70, 46, 0, "StyleData", "3ColumnSmallBox", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22751, 924, 317, 8, 48, 29, 0, "StyleData", "4ColumnBox", "All",
  StyleMenuListing->None],
Cell[23071, 934, 109, 2, 70, 41, 0, "StyleData", "4ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23217, 941, 298, 8, 48, 29, 0, "StyleData", "5ColumnBox", "All",
  StyleMenuListing->None],
Cell[23518, 951, 109, 2, 70, 41, 0, "StyleData", "5ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23664, 958, 329, 8, 48, 29, 0, "StyleData", "6ColumnBox", "All",
  StyleMenuListing->None],
Cell[23996, 968, 109, 2, 70, 41, 0, "StyleData", "6ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24142, 975, 319, 9, 49, 34, 0, "StyleData", "ItemizedNoteBox", "All",
  StyleMenuListing->None],
Cell[24464, 986, 97, 2, 70, 46, 0, "StyleData", "ItemizedNoteBox", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[24598, 993, 378, 13, 49, 32, 0, "StyleData", "DefinitionBox", "All"],
Cell[24979, 1008, 128, 3, 52, 44, 0, "StyleData", "DefinitionBox", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[25144, 1016, 361, 12, 49, 36, 0, "StyleData", "DefinitionBox3Col", 
"All"],
Cell[25508, 1030, 132, 3, 52, 48, 0, "StyleData", "DefinitionBox3Col", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25677, 1038, 370, 12, 49, 36, 0, "StyleData", "DefinitionBox4Col", 
"All"],
Cell[26050, 1052, 132, 3, 52, 48, 0, "StyleData", "DefinitionBox4Col", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26219, 1060, 349, 12, 49, 36, 0, "StyleData", "DefinitionBox5Col", 
"All"],
Cell[26571, 1074, 132, 3, 52, 48, 0, "StyleData", "DefinitionBox5Col", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26740, 1082, 382, 12, 49, 36, 0, "StyleData", "DefinitionBox6Col", 
"All"],
Cell[27125, 1096, 132, 3, 52, 48, 0, "StyleData", "DefinitionBox6Col", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27294, 1104, 443, 15, 48, 25, 0, "StyleData", "TopBox", "All",
  StyleMenuListing->None],
Cell[27740, 1121, 105, 2, 52, 37, 0, "StyleData", "TopBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27882, 1128, 445, 15, 48, 28, 0, "StyleData", "MiddleBox", "All",
  StyleMenuListing->None],
Cell[28330, 1145, 108, 2, 44, 40, 0, "StyleData", "MiddleBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28475, 1152, 447, 15, 48, 28, 0, "StyleData", "BottomBox", "All",
  StyleMenuListing->None],
Cell[28925, 1169, 124, 3, 43, 40, 0, "StyleData", "BottomBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29086, 1177, 446, 15, 48, 29, 0, "StyleData", "TopSpanBox", "All",
  StyleMenuListing->None],
Cell[29535, 1194, 125, 3, 51, 41, 0, "StyleData", "TopSpanBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29697, 1202, 447, 15, 48, 32, 0, "StyleData", "MiddleSpanBox", "All",
  StyleMenuListing->None],
Cell[30147, 1219, 128, 3, 51, 44, 0, "StyleData", "MiddleSpanBox", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[30312, 1227, 153, 4, 32, 26, 0, "StyleData", "Picture", "All",
  StyleMenuListing->None],
Cell[30468, 1233, 71, 1, 70, 38, 0, "StyleData", "Picture", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30576, 1239, 194, 5, 32, 34, 0, "StyleData", "ItemizedPicture", "All",
  StyleMenuListing->None],
Cell[30773, 1246, 80, 1, 70, 46, 0, "StyleData", "ItemizedPicture", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30890, 1252, 173, 4, 32, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[31066, 1258, 76, 1, 70, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31179, 1264, 92, 2, 32, 24, 0, "StyleData", "Sound", "All",
  StyleMenuListing->None],
Cell[31274, 1268, 69, 1, 70, 36, 0, "StyleData", "Sound", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31380, 1274, 179, 6, 30, 26, 0, "StyleData", "Caption", "All",
  StyleMenuListing->None],
Cell[31562, 1282, 86, 2, 70, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31697, 1290, 31, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[31753, 1294, 243, 7, 70, 31, 0, "StyleData", "2ColumnTable", "All",
  StyleMenuListing->None],
Cell[31999, 1303, 76, 1, 70, 43, 0, "StyleData", "2ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32112, 1309, 239, 7, 70, 35, 0, "StyleData", "2ColumnEvenTable", "All",
  StyleMenuListing->None],
Cell[32354, 1318, 80, 1, 70, 47, 0, "StyleData", "2ColumnEvenTable", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32471, 1324, 249, 7, 70, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[32723, 1333, 76, 1, 70, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32848, 1340, 49, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[32922, 1344, 268, 8, 36, 32, 0, "StyleData", "InlineFormula", "All",
  StyleMenuListing->None],
Cell[33193, 1354, 77, 1, 70, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33307, 1360, 175, 5, 32, 31, 0, "StyleData", "InlineOutput", "All",
  StyleMenuListing->None],
Cell[33485, 1367, 93, 2, 70, 43, 0, "StyleData", "InlineOutput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33615, 1374, 342, 9, 36, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[33960, 1385, 96, 1, 42, 45, 0, "StyleData", "DisplayFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[34093, 1391, 415, 13, 39, 30, 0, "StyleData", "DisplayMath", "All",
  CounterIncrements->"Input"],
Cell[34511, 1406, 91, 2, 38, 42, 0, "StyleData", "DisplayMath", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34639, 1413, 344, 8, 39, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[34986, 1423, 99, 2, 37, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[35122, 1430, 59, 1, 36, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[35184, 1433, 70, 1, 36, 45, 0, "StyleData", "EquationNumber", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[35291, 1439, 187, 5, 36, 26, 0, "StyleData", "Program", "All",
  StyleMenuListing->None],
Cell[35481, 1446, 105, 2, 41, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35635, 1454, 51, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[35711, 1458, 179, 6, 43, 29, 0, "StyleData", "ObjectName", "All",
  StyleMenuListing->None],
Cell[35893, 1466, 91, 2, 70, 41, 0, "StyleData", "ObjectName", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36021, 1473, 210, 7, 36, 26, 0, "StyleData", "Command", "All",
  CounterIncrements->"Section",
  StyleMenuListing->None],
Cell[36234, 1482, 113, 3, 70, 38, 0, "StyleData", "Command", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36384, 1490, 176, 5, 41, 32, 0, "StyleData", "CharacterName", "All",
  StyleMenuListing->None],
Cell[36563, 1497, 77, 1, 70, 44, 0, "StyleData", "CharacterName", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36677, 1503, 220, 7, 43, 24, 0, "StyleData", "Usage", "All",
  StyleMenuListing->None],
Cell[36900, 1512, 92, 2, 70, 36, 0, "StyleData", "Usage", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37029, 1519, 218, 7, 32, 24, 0, "StyleData", "Notes", "All",
  StyleMenuListing->None],
Cell[37250, 1528, 84, 2, 70, 36, 0, "StyleData", "Notes", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37371, 1535, 217, 7, 34, 28, 0, "StyleData", "NotesList", "All",
  StyleMenuListing->None],
Cell[37591, 1544, 89, 2, 70, 40, 0, "StyleData", "NotesList", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37717, 1551, 350, 11, 45, 33, 0, "StyleData", "ExampleSection", "All",
  StyleMenuListing->None],
Cell[38070, 1564, 146, 4, 70, 45, 0, "StyleData", "ExampleSection", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38253, 1573, 179, 5, 32, 30, 0, "StyleData", "ExampleText", "All",
  StyleMenuListing->None],
Cell[38435, 1580, 143, 4, 70, 42, 0, "StyleData", "ExampleText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38615, 1589, 233, 7, 31, 36, 0, "StyleData", "ExampleSubsection", "All",
  StyleMenuListing->None],
Cell[38851, 1598, 123, 3, 70, 48, 0, "StyleData", "ExampleSubsection", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39011, 1606, 292, 9, 50, 27, 0, "StyleData", "LineHead", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubection", 0}},
  StyleMenuListing->None],
Cell[39306, 1617, 98, 2, 70, 39, 0, "StyleData", "LineHead", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39441, 1624, 539, 16, 35, 29, 0, "StyleData", "FlushInput", "All",
  StyleMenuListing->None],
Cell[39983, 1642, 100, 2, 70, 41, 0, "StyleData", "FlushInput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40120, 1649, 513, 14, 36, 30, 0, "StyleData", "FlushOutput", "All",
  StyleMenuListing->None],
Cell[40636, 1665, 125, 2, 70, 42, 0, "StyleData", "FlushOutput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40798, 1672, 261, 8, 31, 29, 0, "StyleData", "DialogItem", "All",
  StyleMenuListing->None],
Cell[41062, 1682, 116, 3, 70, 41, 0, "StyleData", "DialogItem", "Printout"]
}, Closed]],
Cell[41193, 1688, 211, 5, 36, 31, 0, "StyleData", "GroupDivider", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[41429, 1697, 193, 6, 63, 28, 0, "StyleData", "Highlight", "All",
  StyleMenuListing->None],
Cell[41625, 1705, 97, 2, 70, 40, 0, "StyleData", "Highlight", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[41759, 1712, 214, 7, 39, 28, 0, "StyleData", "UserNotes", "All",
  StyleMenuListing->None],
Cell[41976, 1721, 111, 3, 70, 40, 0, "StyleData", "UserNotes", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42124, 1729, 255, 8, 47, 27, 0, "StyleData", "MoreInfo", "All",
  StyleMenuListing->None],
Cell[42382, 1739, 110, 3, 70, 39, 0, "StyleData", "MoreInfo", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42529, 1747, 289, 9, 47, 27, 0, "StyleData", "UserTips", "All",
  StyleMenuListing->None],
Cell[42821, 1758, 145, 4, 70, 39, 0, "StyleData", "UserTips", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43003, 1767, 232, 7, 32, 26, 0, "StyleData", "Theorem", "All"],
Cell[43238, 1776, 171, 5, 40, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43446, 1786, 282, 9, 41, 29, 0, "StyleData", "Commentary", "All"],
Cell[43731, 1797, 125, 3, 39, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43905, 1806, 43, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[43973, 1810, 184, 6, 55, 32, 0, "StyleData", "ContentsTitle", "All",
  StyleMenuListing->None],
Cell[44160, 1818, 119, 3, 70, 44, 0, "StyleData", "ContentsTitle", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[44316, 1826, 220, 7, 37, 34, 0, "StyleData", "ContentsSection", "All",
  StyleMenuListing->None],
Cell[44539, 1835, 106, 2, 70, 46, 0, "StyleData", "ContentsSection", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[44682, 1842, 217, 7, 39, 31, 0, "StyleData", "IndexSection", "All",
  StyleMenuListing->None],
Cell[44902, 1851, 103, 2, 70, 43, 0, "StyleData", "IndexSection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[45042, 1858, 113, 3, 32, 27, 0, "StyleData", "Contents", "All",
  StyleMenuListing->None],
Cell[45158, 1863, 73, 1, 70, 39, 0, "StyleData", "Contents", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[45268, 1869, 134, 4, 32, 24, 0, "StyleData", "Index", "All",
  StyleMenuListing->None],
Cell[45405, 1875, 85, 2, 70, 36, 0, "StyleData", "Index", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[45527, 1882, 142, 4, 32, 32, 0, "StyleData", "IndexSubentry", "All",
  StyleMenuListing->None],
Cell[45672, 1888, 93, 2, 70, 44, 0, "StyleData", "IndexSubentry", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[45814, 1896, 41, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[45880, 1900, 160, 5, 70, 24, 0, "StyleData", "Line1", "All",
  StyleMenuListing->None],
Cell[46043, 1907, 71, 1, 70, 36, 0, "StyleData", "Line1", "Printout"]
}, Closed]],
Cell[46129, 1911, 65, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[46219, 1918, 194, 6, 70, 29, 0, "StyleData", "ProgramTop", "All",
  StyleMenuListing->None],
Cell[46416, 1926, 77, 1, 70, 41, 0, "StyleData", "ProgramTop", "Printout"]
}, Closed]],
Cell[46508, 1930, 61, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[46594, 1938, 197, 6, 70, 32, 0, "StyleData", "ProgramBottom", "All",
  StyleMenuListing->None],
Cell[46794, 1946, 80, 1, 70, 44, 0, "StyleData", "ProgramBottom", "Printout"]
}, Closed]],
Cell[46889, 1950, 64, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[46978, 1958, 220, 7, 70, 31, 0, "StyleData", "SessionLabel", "All",
  StyleMenuListing->None],
Cell[47201, 1967, 93, 2, 70, 43, 0, "StyleData", "SessionLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[47343, 1975, 49, 0, 28, "Subsubsection"],
Cell[47395, 1977, 126, 4, 70, 29, 0, "StyleData", "PageHeader", "All",
  StyleMenuListing->None],
Cell[47524, 1983, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[47679, 1990, 97, 3, 70, 29, 0, "StyleData", "PageFooter", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

